﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Data;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.Entities
{
    public class Subscription : BusinessBaseClass
    {

        public Subscription()
        {

        }

        public Subscription(IDataReader myDataRecord)
        {
            UniqueID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ContactUsID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ContactUsID"));
            Salutaion = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Salutaion")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Salutaion"));
            FullName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("FullName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("FullName"));
            Email = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("Email")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("Email"));
            CompanyName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CompanyName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("CompanyName"));
            IsSubscribed = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsSubscribed")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsSubscribed"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            //IsDeleted = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsDeleted")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsDeleted"));
        }

        [DataObjectField(true, false, false)]
        public override Guid UniqueID { get; set; }

        public string Salutaion { get; set; }

        public string FullName { get; set; }

        public string Email { get; set; }

        public string CompanyName { get; set; }

        public bool IsSubscribed { get; set; }

        public override DateTime CreatedDate { get; set; }

        public override DateTime ModifiedDate { get; set; }

        public override GlobalConfigurations.Mode Mode { get; set; }

        public override bool IsActive { get; set; }
    }
}
